#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/sl/header.h"
#include "levels/bbh/header.h"

extern u8 _sl_segment_ESegmentRomStart[];
extern u8 _sl_segment_ESegmentRomEnd[];

const LevelScript level_sl_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _sl_segment_ESegmentRomStart, _sl_segment_ESegmentRomEnd),
LOAD_MIO0(        /*seg*/ 0x0B, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd),
LOAD_MIO0(0xA, _ccm_skybox_mio0SegmentRomStart, _ccm_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group1_mio0SegmentRomStart, _group1_mio0SegmentRomEnd),
LOAD_RAW(12, _group1_geoSegmentRomStart, _group1_geoSegmentRomEnd),
LOAD_MIO0(6, _group16_mio0SegmentRomStart, _group16_mio0SegmentRomEnd),
LOAD_RAW(13, _group16_geoSegmentRomStart, _group16_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_GEO(100, 0x06003754),
// LOAD_MODEL_FROM_GEO(101, 0x06003874),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_2),
JUMP_LINK(script_func_global_17),
JUMP_LINK(local_area_sl_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_sl_1_[] = {
AREA(1, Geo_sl_1_0x15f2dd0),
TERRAIN(col_sl_1_0xe01df80),
SET_BACKGROUND_MUSIC(0, 50),
TERRAIN_TYPE(2),
JUMP_LINK(local_objects_sl_1_),
JUMP_LINK(local_warps_sl_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_sl_1_[] = {
OBJECT_WITH_ACTS(0, 13726, 4024, -7169, 0, 270, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, 9124, 7166, -7795, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 14183, 6790, -12527, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(101, 2161, 2750, -13727, 0, 0, 0, 0x2000000,  bhvBigChillBully, 31),
OBJECT_WITH_ACTS(0, 1876, 3360, -6778, 0, 0, 0, 0x3000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(137, 1658, 1950, -900, 0, 333, 0, 0xd0000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 6591, 3580, -3535, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(0, 1861, 3635, -1530, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 10806, 3555, -1309, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 10196, 6070, -10068, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 6757, 3555, -1364, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 301, 6210, -10431, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(215, 4456, 7170, -5102, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 4576, 7170, -3391, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 5175, 7170, -2900, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6447, 7170, -2923, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6512, 7170, -5368, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6837, 7170, -4492, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6888, 7170, -3743, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 5330, 7170, -4334, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(25, 1856, 3125, -1511, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 6755, 3075, -1378, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 10796, 3075, -1321, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 292, 5700, -10422, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 10190, 5525, -10070, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(137, 12592, 3480, -11673, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 5063, 6390, -11034, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 1342, 3410, -2867, 0, 36, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(223, 6216, 2950, -5299, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 1118, 4600, -8052, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 13669, 3000, -9522, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 2570, 3000, -5806, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 8893, 9575, -9409, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4540, 5750, -9244, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(180, 8283, 8250, -11056, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(223, 10175, 2250, -6327, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 7284, 3000, -7202, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(180, 13016, 3150, -3591, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(0, 2776, 5625, -11846, 0, 335, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 9095, 3000, -6333, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 10537, 2250, -6845, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(25, 5596, 7950, -11082, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(0, 10473, 5500, -9198, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 13441, 3450, -11750, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(192, 3842, 5625, -10729, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, 9397, 3000, -4352, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(89, 6538, 2975, -12279, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(180, 10208, 2814, -11274, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(89, 4397, 3000, -6689, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(223, 2340, 3000, -2106, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 11051, 2445, -9928, 0, 18, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(140, 7927, 9575, -10267, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, 7261, 10186, -10175, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 6818, 10456, -9690, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 6809, 10415, -8826, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 6821, 10385, -7955, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(180, 10516, 9285, -8594, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(0, 1524, 2500, -682, 0, 335, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(180, 10349, 8450, -9966, 0, 148, 0, 0x0,  bhvFireSpitter, 31),
// OBJECT_WITH_ACTS(0, 15, 5, 4, 255, 0, 20, 2,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_sl_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 2, 44, 0),
WARP_NODE(241, 6, 2, 54, 0),
RETURN()
};
